' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox. 
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com. 
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Drawing
Imports Toolkit

Partial Class Controls_RotateFlipImage
    Inherits System.Web.UI.UserControl

  Public Delegate Sub ImageFinalizedEventHandler(ByVal sender As System.Object, _
      ByVal e As FileHandlingEventArgs)
  Public Event ImageFinalized As ImageFinalizedEventHandler

  Private Sub InitializeControl()
    lstRotateFlipTypes.DataSource = Imaging.GetRotateTypes()
    lstRotateFlipTypes.DataBind()
    UpdateImageControl(FileName)
  End Sub

  Protected Sub btnRotate_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnRotate.Click
    Dim myRotateFlipType As RotateFlipType = [Enum].Parse(GetType(RotateFlipType), _
               lstRotateFlipTypes.SelectedValue)
    Imaging.RotateImage(Server.MapPath(FileName), Server.MapPath(TempFileName), _
             myRotateFlipType)
    HasBeenRotated = True
    plcRotate.Visible = False
    btnUndo.Visible = True
    UpdateImageControl(TempFileName)
  End Sub

  Protected Sub btnUndo_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUndo.Click
    HasBeenRotated = False
    plcRotate.Visible = True
    btnUndo.Visible = False
    UpdateImageControl(FileName)
  End Sub

  Private Sub UpdateImageControl(ByVal theFileName As String)
    Image1.ImageUrl = String.Format("{0}?TimeStamp={1}", theFileName, System.DateTime.Now.Millisecond.ToString())
  End Sub

#Region "Waciwoci i metody wsplne dla wszystkich kontrolek uytkownika"

  Public Property FileName() As String
    Get
      If ViewState("FileName") IsNot Nothing Then
        Return ViewState("FileName").ToString()
      Else
        Return String.Empty
      End If
    End Get
    Set(ByVal value As String)
      If ViewState("FileName") Is Nothing Then
        ViewState("FileName") = value
        InitializeControl()
      Else
        ViewState("FileName") = value
      End If
    End Set
  End Property

  Private ReadOnly Property TempFileName() As String
    Get
      If ViewState("TempFileName") Is Nothing Then
        ViewState("TempFileName") = AppConfiguration.TempImagesFolder & "/" & Guid.NewGuid.ToString() & ".jpg"
      End If
      Return ViewState("TempFileName").ToString()
    End Get
  End Property

  Public Property FinishButtonText() As String
    Get
      Return btnFinish.Text
    End Get
    Set(ByVal value As String)
      btnFinish.Text = value
    End Set
  End Property

  Protected Sub btnFinish_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnFinish.Click
    If HasBeenRotated Then
      FileName = TempFileName
    End If
    RaiseEvent ImageFinalized(Me, New FileHandlingEventArgs(FileName))
  End Sub

#End Region

#Region "Prywatne wasciwoci"

  Private Property HasBeenRotated() As Boolean
    Get
      If ViewState("HasBeenRotated") IsNot Nothing Then
        Return Convert.ToBoolean(ViewState("HasBeenRotated"))
      Else
        Return False
      End If
    End Get
    Set(ByVal value As Boolean)
      ViewState("HasBeenRotated") = value
    End Set
  End Property

#End Region

End Class
